/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.region.service.lbs.entity;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 经纬度
 *
 * @author guer
 */
@Data
@Schema(name = "Location", description = "经纬度")
public class Location {

    /**
     * 纬度
     */
    @Schema(description = "纬度")
    private BigDecimal lng;

    /**
     * 经度
     */
    @Schema(description = "经度")
    private BigDecimal lat;
}
