/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.region.service.lbs.entity;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

/**
 * 响应结果
 *
 * @author guer
 */
@Data
@Schema(name = "LbsResponse", description = "响应结果")
public class LbsResponse<T> {

    /**
     * 响应状态码
     */
    @Schema(description = "响应状态码")
    private Integer status;

    /**
     * 响应消息
     */
    @Schema(description = "响应消息")
    private String message;

    /**
     * 响应数据
     */
    @Schema(description = "响应数据")
    private T result;
}
