/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.region.service.lbs.entity;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

/**
 * IP定位查询响应
 *
 * @author guer
 */
@Data
@Schema(name = "IpQueryResult", description = "IP定位查询响应")
public class IpQueryResult {

    /**
     * 用于定位的IP地址
     */
    @Schema(description = "用于定位的IP地址")
    private String ip;

    /**
     * 定位坐标
     */
    @Schema(description = "定位坐标")
    private Location location;

    /**
     * 定位行政区划信息
     */
    @JsonProperty("ad_info")
    @Schema(description = "定位行政区划信息")
    private AddressInfo addressInfo;

    /**
     * 定位行政区划信息
     */
    @Data
    @Schema(name = "IpQueryResult_AddressInfo", description = "定位行政区划信息")
    public static class AddressInfo {

        /**
         * 国家
         */
        @Schema(description = "国家")
        private String nation;

        /**
         * 省
         */
        @Schema(description = "省")
        private String province;

        /**
         * 市
         */
        @Schema(description = "市")
        private String city;

        /**
         * 区
         */
        @Schema(description = "区")
        private String district;

        /**
         * 行政区划代码
         */
        @Schema(description = "行政区划代码")
        @JsonProperty("adcode")
        private Long adCode;
    }
}
