/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.region.service.lbs.entity;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

/**
 * 行政区划
 *
 * @author guer
 */
@Data
@Schema(name = "District", description = "行政区划")
public class District {

    /**
     * 行政区划唯一标识（adcode）
     */
    @Schema(description = "行政区划唯一标识（adcode）")
    private Long id;

    /**
     * 简称
     */
    @Schema(description = "简称")
    private String name;

    /**
     * 全称
     */
    @Schema(description = "全称")
    @JsonProperty("fullname")
    private String fullName;

    /**
     * 经纬度
     */
    @Schema(description = "经纬度")
    private Location location;
}
