/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.region.service.lbs;

import net.guerlab.loadbalancer.ILoadBalancer;
import net.guerlab.loadbalancer.RoundRobinLoadBalancer;
import net.guerlab.loadbalancer.TargetWrapper;
import net.guerlab.smart.region.service.lbs.properties.LbsProperties;
import net.guerlab.spring.commons.util.SpringApplicationContextUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.scope.refresh.RefreshScopeRefreshedEvent;
import org.springframework.context.event.EventListener;

/**
 * key负载均衡代理
 *
 * @author guer
 */
public class KeyLoadBalancerAgent {

    private final ILoadBalancer<String, Object> keyLoadBalancer = new RoundRobinLoadBalancer<>();

    public void refreshLbsProperties(LbsProperties lbsProperties) {
        keyLoadBalancer.clear();
        keyLoadBalancer.addTargets(lbsProperties.getKeys(), true);
    }

    public String choose() {
        return keyLoadBalancer.choose();
    }

    public void markDown(String target) {
        if (target == null) {
            return;
        }

        keyLoadBalancer.markDown(TargetWrapper.of(target));
    }

    @EventListener(RefreshScopeRefreshedEvent.class)
    public void lbsPropertiesRefreshedHandler() {
        refreshLbsProperties(SpringApplicationContextUtil.getContext().getBean(LbsProperties.class));
    }

    @Autowired
    public void setProperties(LbsProperties properties) {
        refreshLbsProperties(properties);
    }
}
