/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.region.service.entity;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import net.guerlab.smart.platform.commons.entity.BaseOrderEntity;
import net.guerlab.smart.region.core.domain.RegionDTO;
import net.guerlab.spring.commons.dto.DefaultConvert;

import java.math.BigDecimal;

/**
 * 地区
 *
 * @author guer
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("region_region")
public class Region extends BaseOrderEntity<Region> implements DefaultConvert<RegionDTO> {

    /**
     * 地区ID
     */
    @TableId
    private Long regionId;

    /**
     * 地区名称
     */
    private String regionName;

    /**
     * 地区全称
     */
    private String fullName;

    /**
     * 上级ID
     */
    private Long parentId;

    /**
     * 经度
     */
    private BigDecimal longitude;

    /**
     * 纬度
     */
    private BigDecimal latitude;
}
