/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.region.service.autoconfigure;

import net.guerlab.smart.region.service.lbs.KeyLoadBalancerAgent;
import net.guerlab.smart.region.service.lbs.properties.LbsProperties;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.scheduling.annotation.EnableScheduling;

/**
 * 地区服务自动注册
 *
 * @author guer
 */
@EnableScheduling
@Configurable
@ComponentScan("net.guerlab.smart.region.service")
@MapperScan("net.guerlab.smart.region.service.mapper")
@EnableConfigurationProperties(LbsProperties.class)
public class RegionServiceAutoconfigure {

    @Bean
    public KeyLoadBalancerAgent keyLoadBalancerAgent(LbsProperties properties) {
        KeyLoadBalancerAgent agent = new KeyLoadBalancerAgent();
        agent.setProperties(properties);
        return agent;
    }
}
