/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.region.service.lbs.service.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.smart.region.core.entity.GeocoderResult;
import net.guerlab.smart.region.service.lbs.entity.LbsResponse;
import net.guerlab.smart.region.service.lbs.service.SearchService;
import net.guerlab.smart.region.service.lbs.service.impl.AbstractServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SearchServiceImpl
extends AbstractServiceImpl
implements SearchService {
    private static final Logger log = LoggerFactory.getLogger(SearchServiceImpl.class);

    @Override
    public GeocoderResult geocoder(String address) {
        int retryNumber = this.getRetryNumber();
        int i = 0;
        while (true) {
            ++i;
            try {
                String key = this.getKey();
                String content = this.getResult("https://apis.map.qq.com/ws/geocoder/v1/?address=" + address + "&key=" + key);
                LbsResponse result = (LbsResponse)this.objectMapper.readValue(content, (TypeReference)new TypeReference<LbsResponse<GeocoderResult>>(){});
                GeocoderResult data = (GeocoderResult)this.resultCheck(key, result);
                this.dataCheck(data);
                return data;
            }
            catch (Exception e) {
                if (i < retryNumber) continue;
                throw e instanceof ApplicationException ? (ApplicationException)e : new ApplicationException((Throwable)e);
            }
            break;
        }
    }
}

