package net.guerlab.smart.region.service.lbs.service.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import lombok.extern.slf4j.Slf4j;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.smart.region.core.entity.GeocoderResult;
import net.guerlab.smart.region.service.lbs.entity.LbsResponse;
import net.guerlab.smart.region.service.lbs.service.SearchService;
import org.springframework.stereotype.Component;

/**
 * 搜索服务实现
 *
 * @author guer
 */
@Slf4j
@Component
public class SearchServiceImpl extends AbstractServiceImpl implements SearchService {

    @Override
    public GeocoderResult geocoder(String address) {
        int retryNumber = getRetryNumber();
        int i = 0;
        while (true) {
            i++;
            try {
                String key = getKey();
                String content = getResult(
                        "https://apis.map.qq.com/ws/geocoder/v1/?address=" + address + "&key=" + key);
                LbsResponse<GeocoderResult> result = objectMapper.readValue(content, new TypeReference<>() {});
                GeocoderResult data = resultCheck(key, result);
                dataCheck(data);
                return data;
            } catch (Exception e) {
                if (i >= retryNumber) {
                    throw e instanceof ApplicationException ? (ApplicationException) e : new ApplicationException(e);
                }
            }
        }
    }
}
