package net.guerlab.smart.region.service.lbs.service.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import lombok.extern.slf4j.Slf4j;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.smart.region.service.lbs.entity.IpQueryResult;
import net.guerlab.smart.region.service.lbs.entity.LbsResponse;
import net.guerlab.smart.region.service.lbs.service.IpService;
import org.springframework.stereotype.Component;

/**
 * IP地址服务实现
 *
 * @author guer
 */
@Slf4j
@Component
public class IpServiceImpl extends AbstractServiceImpl implements IpService {

    @Override
    public IpQueryResult query(String ip) {
        int retryNumber = getRetryNumber();
        int i = 0;
        while (true) {
            i++;
            try {
                String key = getKey();
                String content = getResult("https://apis.map.qq.com/ws/location/v1/ip?ip=" + ip + "&key=" + key);
                LbsResponse<IpQueryResult> result = objectMapper.readValue(content, new TypeReference<>() {});
                IpQueryResult data = resultCheck(key, result);
                dataCheck(data);
                return data;
            } catch (Exception e) {
                if (i >= retryNumber) {
                    throw e instanceof ApplicationException ? (ApplicationException) e : new ApplicationException(e);
                }
            }
        }
    }
}
