package net.guerlab.smart.region.service.lbs.properties;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.util.ArrayList;
import java.util.List;

/**
 * lbs配置
 *
 * @author guer
 */
@Data
@ConfigurationProperties("lbs")
public class LbsProperties {

    /**
     * 默认重试次数
     */
    public static final int DEFAULT_RETRY_NUMBER = 3;

    /**
     * key列表
     */
    private List<String> keys = new ArrayList<>();

    /**
     * 重试次数
     */
    private int retryNumber = 3;
}
