package net.guerlab.smart.region.service.lbs.entity;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * IP定位查询响应
 *
 * @author guer
 */
@Data
@ApiModel("IP定位查询响应")
public class IpQueryResult {

    /**
     * 用于定位的IP地址
     */
    @ApiModelProperty("用于定位的IP地址")
    private String ip;

    /**
     * 定位坐标
     */
    @ApiModelProperty("定位坐标")
    private Location location;

    /**
     * 定位行政区划信息
     */
    @JsonProperty("ad_info")
    @ApiModelProperty("定位行政区划信息")
    private AddressInfo addressInfo;

    /**
     * 定位行政区划信息
     */
    @Data
    @ApiModel("定位行政区划信息")
    public static class AddressInfo {

        /**
         * 国家
         */
        @ApiModelProperty("国家")
        private String nation;

        /**
         * 省
         */
        @ApiModelProperty("省")
        private String province;

        /**
         * 市
         */
        @ApiModelProperty("市")
        private String city;

        /**
         * 区
         */
        @ApiModelProperty("区")
        private String district;

        /**
         * 行政区划代码
         */
        @ApiModelProperty("行政区划代码")
        @JsonProperty("adcode")
        private Long adCode;
    }
}
