package net.guerlab.smart.region.service.lbs.entity;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 行政区划
 *
 * @author guer
 */
@Data
public class District {

    /**
     * 行政区划唯一标识（adcode）
     */
    @ApiModelProperty("行政区划唯一标识（adcode）")
    private Long id;

    /**
     * 简称
     */
    @ApiModelProperty("简称")
    private String name;

    /**
     * 全称
     */
    @ApiModelProperty("全称")
    @JsonProperty("fullname")
    private String fullName;

    /**
     * 经纬度
     */
    @ApiModelProperty("经纬度")
    private Location location;
}
