package net.guerlab.smart.region.service.entity;

import lombok.Data;
import lombok.EqualsAndHashCode;
import net.guerlab.smart.platform.commons.entity.BaseOrderEntity;
import net.guerlab.smart.region.core.domain.RegionDTO;
import net.guerlab.spring.commons.dto.DefaultConvertDTO;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * 地区
 *
 * @author guer
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Table(name = "region_region")
public class Region extends BaseOrderEntity<Region> implements DefaultConvertDTO<RegionDTO> {

    /**
     * 地区ID
     */
    @Id
    private Long regionId;

    /**
     * 地区名称
     */
    @Column(name = "regionName", nullable = false)
    private String regionName;

    /**
     * 地区全称
     */
    @Column(name = "fullName", nullable = false)
    private String fullName;

    /**
     * 上级ID
     */
    @Column(name = "parentId", nullable = false)
    private Long parentId;

    /**
     * 经度
     */
    @Column(name = "longitude", nullable = false)
    private BigDecimal longitude;

    /**
     * 纬度
     */
    @Column(name = "latitude", nullable = false)
    private BigDecimal latitude;
}
