/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.region.service.service.impl;

import net.guerlab.commons.number.NumberHelper;
import net.guerlab.smart.platform.commons.Constants;
import net.guerlab.smart.platform.commons.entity.IOrderEntity;
import net.guerlab.smart.platform.commons.util.OrderEntityUtils;
import net.guerlab.smart.platform.server.service.BaseServiceImpl;
import net.guerlab.smart.region.core.exception.ParentRegionInvalidException;
import net.guerlab.smart.region.core.exception.RegionDisallowDeleteException;
import net.guerlab.smart.region.core.exception.RegionIdInvalidException;
import net.guerlab.smart.region.core.exception.RegionIdRepeatException;
import net.guerlab.smart.region.core.exception.RegionNameInvalidException;
import net.guerlab.smart.region.core.exception.RegionNameLengthErrorException;
import net.guerlab.smart.region.core.searchparams.RegionSearchParams;
import net.guerlab.smart.region.service.entity.Region;
import net.guerlab.smart.region.service.mapper.RegionMapper;
import net.guerlab.smart.region.service.service.RegionService;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class RegionServiceImpl
extends BaseServiceImpl<Region, Long, RegionMapper>
implements RegionService {
    protected void insertBefore(Region entity) {
        Long regionId = entity.getRegionId();
        String name = StringUtils.trimToNull((String)entity.getRegionName());
        Long parentId = entity.getParentId();
        if (name == null) {
            throw new RegionNameInvalidException();
        }
        if (name.length() > 100) {
            throw new RegionNameLengthErrorException();
        }
        if (!NumberHelper.greaterZero((Number)regionId)) {
            throw new RegionIdInvalidException();
        }
        if (this.selectById(regionId) != null) {
            throw new RegionIdRepeatException();
        }
        if (NumberHelper.greaterZero((Number)parentId)) {
            Region parent = (Region)((Object)this.selectById(parentId));
            if (parent == null) {
                throw new ParentRegionInvalidException();
            }
        } else {
            entity.setParentId(Constants.DEFAULT_PARENT_ID);
        }
        entity.setRegionName(name);
        OrderEntityUtils.propertiesCheck((IOrderEntity)entity);
    }

    protected void updateBefore(Region entity) {
        String name = StringUtils.trimToNull((String)entity.getRegionName());
        if (name != null && name.length() > 100) {
            throw new RegionNameLengthErrorException();
        }
        entity.setRegionName(name);
        Long parentId = entity.getParentId();
        if (NumberHelper.greaterZero((Number)parentId)) {
            Region parent = (Region)((Object)this.selectById(parentId));
            if (parent == null) {
                throw new ParentRegionInvalidException();
            }
        } else {
            entity.setParentId(null);
        }
    }

    protected void deleteBefore(Region entity, Boolean force) {
        this.deleteByIdBefore(entity.getRegionId(), force);
    }

    protected void deleteByIdBefore(Long id, Boolean force) {
        RegionSearchParams searchParams = new RegionSearchParams();
        searchParams.setParentId(id);
        if (this.selectCount((AbstractSearchParams)searchParams) > 0) {
            throw new RegionDisallowDeleteException();
        }
    }
}

