package net.guerlab.smart.region.service.entity;

import lombok.Data;
import lombok.EqualsAndHashCode;
import net.guerlab.smart.platform.commons.entity.BaseOrderEntity;
import net.guerlab.smart.region.core.domain.RegionDTO;
import net.guerlab.spring.commons.dto.DefaultConvertDTO;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;

/**
 * 地区
 *
 * @author guer
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Table(name = "region_region")
public class Region extends BaseOrderEntity<Region> implements DefaultConvertDTO<RegionDTO> {

    /**
     * 地区ID
     */
    @Id
    private Long regionId;

    /**
     * 地区名称
     */
    @Column(name = "regionName", nullable = false)
    private String regionName;

    /**
     * 上级ID
     */
    @Column(name = "parentId", nullable = false)
    private Long parentId;
}
