package net.guerlab.smart.region.internal.controller.inside;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiParam;
import net.guerlab.commons.collection.CollectionUtil;
import net.guerlab.smart.platform.commons.util.BeanConvertUtils;
import net.guerlab.smart.platform.commons.util.TreeUtils;
import net.guerlab.smart.region.core.domain.RegionDTO;
import net.guerlab.smart.region.core.exception.RegionIdInvalidException;
import net.guerlab.smart.region.core.searchparams.RegionSearchParams;
import net.guerlab.smart.region.service.entity.Region;
import net.guerlab.smart.region.service.service.RegionService;
import net.guerlab.web.result.ListObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.web.bind.annotation.*;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 地区
 *
 * @author guer
 */
@Api(tags = "地区")
@RestController("/inside/region")
@RequestMapping("/inside/region")
public class RegionController {

    private RegionService service;

    @GetMapping("/{id}")
    public RegionDTO findOne(@ApiParam(value = "id", required = true) @PathVariable Long id) {
        return service.selectByIdOptional(id).orElseThrow(RegionIdInvalidException::new).toDTO();
    }

    @PostMapping
    public ListObject<RegionDTO> findList(@RequestBody RegionSearchParams searchParams) {
        return BeanConvertUtils.toListObject(service.selectPage(searchParams));
    }

    @PostMapping("/all")
    public List<RegionDTO> findAll(@RequestBody RegionSearchParams searchParams) {
        return BeanConvertUtils.toList(service.selectAll(searchParams));
    }

    @Cacheable(value = "region", key = "'tree'")
    @GetMapping("/tree")
    public Collection<RegionDTO> getTree() {
        return TreeUtils.tree(CollectionUtil.toList(service.selectAll(), Region::toDTO));
    }

    @GetMapping("/{id}/depth")
    public Collection<RegionDTO> findDepthList(@ApiParam(value = "id", required = true) @PathVariable Long id) {
        return service.findDepthList(id).stream().map(Region::toDTO).collect(Collectors.toList());
    }

    @Autowired
    public void setService(RegionService service) {
        this.service = service;
    }
}
