/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.region.internal.controller.inside;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiParam;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.guerlab.commons.collection.CollectionUtil;
import net.guerlab.smart.platform.commons.util.BeanConvertUtils;
import net.guerlab.smart.platform.commons.util.TreeUtils;
import net.guerlab.smart.region.core.domain.RegionDTO;
import net.guerlab.smart.region.core.exception.RegionIdInvalidException;
import net.guerlab.smart.region.core.searchparams.RegionSearchParams;
import net.guerlab.smart.region.service.entity.Region;
import net.guerlab.smart.region.service.service.RegionService;
import net.guerlab.spring.commons.dto.DefaultConvertDTO;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import net.guerlab.web.result.ListObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5730\u533a"})
@RestController(value="/inside/region")
@RequestMapping(value={"/inside/region"})
public class RegionController {
    private RegionService service;

    @GetMapping(value={"/{id}"})
    public RegionDTO findOne(@ApiParam(value="id", required=true) @PathVariable Long id) {
        return (RegionDTO)((Region)this.service.selectByIdOptional((Object)id).orElseThrow(RegionIdInvalidException::new)).toDTO();
    }

    @PostMapping
    public ListObject<RegionDTO> findList(@RequestBody RegionSearchParams searchParams) {
        return BeanConvertUtils.toListObject((ListObject)this.service.selectPage((AbstractSearchParams)searchParams));
    }

    @PostMapping(value={"/all"})
    public List<RegionDTO> findAll(@RequestBody RegionSearchParams searchParams) {
        return BeanConvertUtils.toList((Collection)this.service.selectAll((AbstractSearchParams)searchParams));
    }

    @Cacheable(value={"region"}, key="'tree'")
    @GetMapping(value={"/tree"})
    public Collection<RegionDTO> getTree() {
        return TreeUtils.tree((Collection)CollectionUtil.toList((Collection)this.service.selectAll(), DefaultConvertDTO::toDTO));
    }

    @GetMapping(value={"/{id}/depth"})
    public Collection<RegionDTO> findDepthList(@ApiParam(value="id", required=true) @PathVariable Long id) {
        return this.service.findDepthList(id).stream().map(DefaultConvertDTO::toDTO).collect(Collectors.toList());
    }

    @Autowired
    public void setService(RegionService service) {
        this.service = service;
    }
}

