package net.guerlab.smart.region.internal.controller.inside;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiParam;
import net.guerlab.smart.platform.commons.util.BeanConvertUtils;
import net.guerlab.smart.region.core.domain.ProvinceDTO;
import net.guerlab.smart.region.core.exception.ProvinceIdInvalidException;
import net.guerlab.smart.region.core.searchparams.ProvinceSearchParams;
import net.guerlab.smart.region.service.service.ProvinceService;
import net.guerlab.web.result.ListObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 省
 *
 * @author guer
 */
@Api(tags = "省")
@RestController("/inside/province")
@RequestMapping("/inside/province")
public class ProvinceController {

    private ProvinceService service;

    @GetMapping("/{id}")
    public ProvinceDTO findOne(@ApiParam(value = "id", required = true) @PathVariable Long id) {
        return service.selectByIdOptional(id).orElseThrow(ProvinceIdInvalidException::new).toDTO();
    }

    @PostMapping
    public ListObject<ProvinceDTO> findList(@RequestBody ProvinceSearchParams searchParams) {
        return BeanConvertUtils.toListObject(service.selectPage(searchParams));
    }

    @PostMapping("/all")
    public List<ProvinceDTO> findAll(@RequestBody ProvinceSearchParams searchParams) {
        return BeanConvertUtils.toList(service.selectAll(searchParams));
    }

    @Autowired
    public void setService(ProvinceService service) {
        this.service = service;
    }
}
