package net.guerlab.smart.region.internal.controller.inside;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiParam;
import net.guerlab.smart.platform.commons.util.BeanConvertUtils;
import net.guerlab.smart.region.core.domain.CityDTO;
import net.guerlab.smart.region.core.exception.CityIdInvalidException;
import net.guerlab.smart.region.core.searchparams.CitySearchParams;
import net.guerlab.smart.region.service.service.CityService;
import net.guerlab.web.result.ListObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 市
 *
 * @author guer
 */
@Api(tags = "市")
@RestController("/inside/city")
@RequestMapping("/inside/city")
public class CityController {

    private CityService service;

    @GetMapping("/{id}")
    public CityDTO findOne(@ApiParam(value = "id", required = true) @PathVariable Long id) {
        return service.selectByIdOptional(id).orElseThrow(CityIdInvalidException::new).toDTO();
    }

    @PostMapping
    public ListObject<CityDTO> findList(@RequestBody CitySearchParams searchParams) {
        return BeanConvertUtils.toListObject(service.selectPage(searchParams));
    }

    @PostMapping("/all")
    public List<CityDTO> findAll(@RequestBody CitySearchParams searchParams) {
        return BeanConvertUtils.toList(service.selectAll(searchParams));
    }

    @Autowired
    public void setService(CityService service) {
        this.service = service;
    }
}
