package net.guerlab.smart.region.internal.controller.inside;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiParam;
import net.guerlab.smart.platform.commons.util.BeanConvertUtils;
import net.guerlab.smart.region.core.domain.AreaDTO;
import net.guerlab.smart.region.core.exception.AreaIdInvalidException;
import net.guerlab.smart.region.core.searchparams.AreaSearchParams;
import net.guerlab.smart.region.service.service.AreaService;
import net.guerlab.web.result.ListObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 区
 *
 * @author guer
 */
@Api(tags = "区")
@RestController("/inside/area")
@RequestMapping("/inside/area")
public class AreaController {

    private AreaService service;

    @GetMapping("/{id}")
    public AreaDTO findOne(@ApiParam(value = "id", required = true) @PathVariable Long id) {
        return service.selectByIdOptional(id).orElseThrow(AreaIdInvalidException::new).toDTO();
    }

    @PostMapping
    public ListObject<AreaDTO> findList(@RequestBody AreaSearchParams searchParams) {
        return BeanConvertUtils.toListObject(service.selectPage(searchParams));
    }

    @PostMapping("/all")
    public List<AreaDTO> findAll(@RequestBody AreaSearchParams searchParams) {
        return BeanConvertUtils.toList(service.selectAll(searchParams));
    }

    @Autowired
    public void setService(AreaService service) {
        this.service = service;
    }
}
