/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.region.internal.controller.inside;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiParam;
import java.util.Collection;
import java.util.List;
import net.guerlab.smart.platform.commons.util.BeanConvertUtils;
import net.guerlab.smart.region.core.domain.CityDTO;
import net.guerlab.smart.region.core.exception.CityIdInvalidException;
import net.guerlab.smart.region.core.searchparams.CitySearchParams;
import net.guerlab.smart.region.service.entity.City;
import net.guerlab.smart.region.service.service.CityService;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import net.guerlab.web.result.ListObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5e02"})
@RestController(value="/inside/city")
@RequestMapping(value={"/inside/city"})
public class CityController {
    private CityService service;

    @GetMapping(value={"/{id}"})
    public CityDTO findOne(@ApiParam(value="id", required=true) @PathVariable Long id) {
        return ((City)this.service.selectByIdOptional((Object)id).orElseThrow(CityIdInvalidException::new)).toDTO();
    }

    @PostMapping
    public ListObject<CityDTO> findList(@RequestBody CitySearchParams searchParams) {
        return BeanConvertUtils.toListObject((ListObject)this.service.selectPage((AbstractSearchParams)searchParams));
    }

    @PostMapping(value={"/all"})
    public List<CityDTO> findAll(@RequestBody CitySearchParams searchParams) {
        return BeanConvertUtils.toList((Collection)this.service.selectAll((AbstractSearchParams)searchParams));
    }

    @Autowired
    public void setService(CityService service) {
        this.service = service;
    }
}

