/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.region.core.searchparams;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import net.guerlab.smart.platform.commons.searchparams.OrderSearchParams;
import net.guerlab.spring.searchparams.SearchModel;
import net.guerlab.spring.searchparams.SearchModelType;

import javax.persistence.Column;

/**
 * 地区搜索参数
 *
 * @author guer
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Schema(name = "RegionSearchParams", description = "地区")
public class RegionSearchParams extends OrderSearchParams {

    /**
     * 地区ID
     */
    @Schema(description = "地区ID")
    private Long regionId;

    /**
     * 地区名称关键字
     */
    @Schema(description = "地区名称关键字")
    @SearchModel(SearchModelType.LIKE)
    @Column(name = "regionName")
    private String regionNameLike;

    /**
     * 上级ID
     */
    @Schema(description = "上级ID")
    private Long parentId;
}
