/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.region.core.entity;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 地址解析响应结果
 *
 * @author guer
 */
@Data
@Schema(name = "GeocoderResult", description = "地址解析响应结果")
public class GeocoderResult {

    /**
     * 定位坐标
     */
    @Schema(description = "定位坐标")
    private Location location;

    /**
     * 定位行政区划信息
     */
    @JsonProperty("ad_info")
    @Schema(description = "定位行政区划信息")
    private AddressInfo addressInfo;

    /**
     * 定位坐标
     */
    @Data
    @Schema(name = "GeocoderResult_Location", description = "定位坐标")
    public static class Location {

        /**
         * 纬度
         */
        @Schema(description = "纬度")
        private BigDecimal lng;

        /**
         * 经度
         */
        @Schema(description = "经度")
        private BigDecimal lat;
    }

    /**
     * 定位行政区划信息
     */
    @Data
    @Schema(name = "GeocoderResult_AddressInfo", description = "定位行政区划信息")
    public static class AddressInfo {

        /**
         * 行政区划代码
         */
        @Schema(description = "行政区划代码")
        @JsonProperty("adcode")
        private Long adCode;
    }
}
