/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.region.core.domain;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import net.guerlab.smart.platform.commons.entity.BaseOrderTreeEntity;

import java.math.BigDecimal;

/**
 * 地区
 *
 * @author guer
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Schema(name = "RegionDTO", description = "地区")
public class RegionDTO extends BaseOrderTreeEntity<RegionDTO> {

    /**
     * 地区ID
     */
    @Schema(description = "地区ID")
    private Long regionId;

    /**
     * 地区名称
     */
    @Schema(description = "地区名称")
    private String regionName;

    /**
     * 地区全称
     */
    @Schema(description = "地区全称")
    private String fullName;

    /**
     * 上级ID
     */
    @Schema(description = "上级ID")
    private Long parentId;

    /**
     * 经度
     */
    @Schema(description = "经度")
    private BigDecimal longitude;

    /**
     * 纬度
     */
    @Schema(description = "纬度")
    private BigDecimal latitude;

    @Override
    public Long id() {
        return regionId;
    }

    @Override
    public Long parentId() {
        return parentId;
    }
}
