package net.guerlab.smart.region.core.searchparams;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import net.guerlab.smart.platform.commons.searchparams.OrderSearchParams;
import net.guerlab.spring.searchparams.SearchModel;
import net.guerlab.spring.searchparams.SearchModelType;

import javax.persistence.Column;

/**
 * 地区
 *
 * @author guer
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel("地区")
public class RegionSearchParams extends OrderSearchParams {

    /**
     * 地区ID
     */
    @ApiModelProperty("地区ID")
    private Long regionId;

    /**
     * 地区名称关键字
     */
    @ApiModelProperty("地区名称关键字")
    @SearchModel(SearchModelType.LIKE)
    @Column(name = "regionName")
    private String regionNameLike;

    /**
     * 上级ID
     */
    @ApiModelProperty("上级ID")
    private Long parentId;
}
