package net.guerlab.smart.region.core.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import net.guerlab.smart.platform.commons.entity.BaseOrderTreeEntity;

/**
 * 地区
 *
 * @author guer
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel("地区")
public class RegionDTO extends BaseOrderTreeEntity<RegionDTO> {

    /**
     * 地区ID
     */
    @ApiModelProperty("地区ID")
    private Long regionId;

    /**
     * 地区名称
     */
    @ApiModelProperty("地区名称")
    private String regionName;

    /**
     * 上级ID
     */
    @ApiModelProperty("上级ID")
    private Long parentId;

    @Override
    public Long id() {
        return regionId;
    }

    @Override
    public Long parentId() {
        return parentId;
    }
}
