package net.guerlab.smart.region.core.searchparams;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import net.guerlab.spring.searchparams.SearchModel;
import net.guerlab.spring.searchparams.SearchModelType;

import javax.persistence.Column;

/**
 * 街道搜索参数
 *
 * @author guer
 */
@Setter
@Getter
@ApiModel("街道搜索参数")
public class StreetSearchParams extends AbstractSearchParams {

    /**
     * 街道ID
     */
    @ApiModelProperty("街道ID")
    private Long streetId;

    /**
     * 街道名称关键字
     */
    @ApiModelProperty("街道名称关键字")
    @Column(name = "streetName")
    @SearchModel(SearchModelType.LIKE)
    private String streetNameLike;

    /**
     * 区ID
     */
    @ApiModelProperty("区ID")
    private Long areaId;

    /**
     * 市ID
     */
    @ApiModelProperty("市ID")
    private Long cityId;

    /**
     * 省ID
     */
    @ApiModelProperty("省ID")
    private Long provinceId;
}
