package net.guerlab.smart.region.core.searchparams;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import net.guerlab.spring.searchparams.SearchModel;
import net.guerlab.spring.searchparams.SearchModelType;

import javax.persistence.Column;

/**
 * 市搜索参数
 *
 * @author guer
 */
@Setter
@Getter
@ApiModel("市搜索参数")
public class CitySearchParams extends AbstractSearchParams {

    /**
     * 市ID
     */
    @ApiModelProperty("市ID")
    private Long cityId;

    /**
     * 城市名称关键字
     */
    @ApiModelProperty("城市名称关键字")
    @Column(name = "cityName")
    @SearchModel(SearchModelType.LIKE)
    private String cityNameLike;

    /**
     * 省ID
     */
    @ApiModelProperty("省ID")
    private Long provinceId;
}
