package net.guerlab.smart.region.core.searchparams;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import net.guerlab.spring.searchparams.SearchModel;
import net.guerlab.spring.searchparams.SearchModelType;

import javax.persistence.Column;

/**
 * 区搜索参数
 *
 * @author guer
 */
@Setter
@Getter
@ApiModel("区搜索参数")
public class AreaSearchParams extends AbstractSearchParams {

    /**
     * 区ID
     */
    @ApiModelProperty("区ID")
    private Long areaId;

    /**
     * 区名称关键字
     */
    @ApiModelProperty("区名称关键字")
    @Column(name = "areaName")
    @SearchModel(SearchModelType.LIKE)
    private String areaNameLike;

    /**
     * 市ID
     */
    @ApiModelProperty("市ID")
    private Long cityId;

    /**
     * 省ID
     */
    @ApiModelProperty("省ID")
    private Long provinceId;
}
