package net.guerlab.smart.region.core.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import net.guerlab.smart.platform.commons.entity.BaseOrderEntity;
import net.guerlab.smart.region.core.enums.RegionType;

/**
 * 街道
 *
 * @author guer
 */
@Data
@ApiModel("街道")
public class StreetDTO extends BaseOrderEntity<StreetDTO> implements IRegion {

    /**
     * 街道ID
     */
    @ApiModelProperty("街道ID")
    private Long streetId;

    /**
     * 街道名称
     */
    @ApiModelProperty("街道名称")
    private String streetName;

    /**
     * 区ID
     */
    @ApiModelProperty("区ID")
    private Long areaId;

    /**
     * 区名称
     */
    @ApiModelProperty("区名称")
    private String areaName;

    /**
     * 市id
     */
    @ApiModelProperty("城市ID")
    private Long cityId;

    /**
     * 市名称
     */
    @ApiModelProperty("城市名称")
    private String cityName;

    /**
     * 省ID
     */
    @ApiModelProperty("省ID")
    private Long provinceId;

    /**
     * 省名称
     */
    @ApiModelProperty("省名称")
    private String provinceName;

    @Override
    public Long getId() {
        return streetId;
    }

    @Override
    public String getName() {
        return streetName;
    }

    @Override
    public Long getParentId() {
        return areaId;
    }

    @Override
    public RegionType getRegionType() {
        return RegionType.STREET;
    }
}
