package net.guerlab.smart.region.core.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import net.guerlab.smart.region.core.enums.RegionType;

import java.io.Serializable;
import java.util.Collection;

/**
 * 简单地区对象
 *
 * @author guer
 */
@Data
@ApiModel("简单地区对象")
public class SimpleRegionDTO implements IRegion, Serializable {

    private Long id;

    private String name;

    private Long parentId;

    private RegionType regionType;

    /**
     * 下级列表
     */
    @ApiModelProperty("下级列表")
    private Collection<SimpleRegionDTO> children;

    @Override
    public Long getId() {
        return id;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public Long getParentId() {
        return parentId;
    }

    @Override
    public RegionType getRegionType() {
        return regionType;
    }
}
