package net.guerlab.smart.region.core.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import net.guerlab.smart.platform.commons.entity.BaseOrderEntity;
import net.guerlab.smart.region.core.enums.RegionType;

import java.util.Collection;

/**
 * 省
 *
 * @author guer
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel("省")
public class ProvinceDTO extends BaseOrderEntity<ProvinceDTO> implements IRegion {

    /**
     * 省ID
     */
    @ApiModelProperty("省ID")
    private Long provinceId;

    /**
     * 省名称
     */
    @ApiModelProperty("省名称")
    private String provinceName;

    /**
     * 市列表
     */
    @ApiModelProperty("市列表")
    private Collection<CityDTO> children;

    @Override
    public Long getId() {
        return provinceId;
    }

    @Override
    public String getName() {
        return provinceName;
    }

    @Override
    public Long getParentId() {
        return null;
    }

    @Override
    public RegionType getRegionType() {
        return RegionType.PROVINCE;
    }
}
