package net.guerlab.smart.region.core.searchparams;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import net.guerlab.spring.searchparams.SearchModel;
import net.guerlab.spring.searchparams.SearchModelType;

import javax.persistence.Column;

/**
 * 省搜索参数
 *
 * @author guer
 */
@Setter
@Getter
@ApiModel("省搜索参数")
public class ProvinceSearchParams extends AbstractSearchParams {

    /**
     * 省ID
     */
    @ApiModelProperty("省ID")
    private Long provinceId;

    /**
     * 省名称关键字
     */
    @ApiModelProperty("省名称关键字")
    @Column(name = "provinceName")
    @SearchModel(SearchModelType.LIKE)
    private String provinceNameLike;
}
