package net.guerlab.smart.region.core.domain;

import net.guerlab.smart.region.core.enums.RegionType;

/**
 * 抽象地区接口
 *
 * @author guer
 */
public interface IRegion {

    /**
     * 获取ID
     *
     * @return ID
     */
    Long getId();

    /**
     * 获取名称
     *
     * @return 名称
     */
    String getName();

    /**
     * 获取上级ID
     *
     * @return 上级ID
     */
    Long getParentId();

    /**
     * 获取区域类型
     *
     * @return 区域类型
     */
    RegionType getRegionType();
}
