package net.guerlab.smart.region.core.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import net.guerlab.smart.platform.commons.entity.BaseOrderEntity;
import net.guerlab.smart.region.core.enums.RegionType;

import java.util.Collection;

/**
 * 区
 *
 * @author guer
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel("区")
public class AreaDTO extends BaseOrderEntity<AreaDTO> implements IRegion {

    /**
     * 区ID
     */
    @ApiModelProperty("区ID")
    private Long areaId;

    /**
     * 区名称
     */
    @ApiModelProperty("区名称")
    private String areaName;

    /**
     * 市id
     */
    @ApiModelProperty("城市ID")
    private Long cityId;

    /**
     * 市名称
     */
    @ApiModelProperty("城市名称")
    private String cityName;

    /**
     * 省ID
     */
    @ApiModelProperty("省ID")
    private Long provinceId;

    /**
     * 省名称
     */
    @ApiModelProperty("省名称")
    private String provinceName;

    /**
     * 街道列表
     */
    @ApiModelProperty("街道列表")
    private Collection<StreetDTO> children;

    @Override
    public Long getId() {
        return areaId;
    }

    @Override
    public String getName() {
        return areaName;
    }

    @Override
    public Long getParentId() {
        return cityId;
    }

    @Override
    public RegionType getRegionType() {
        return RegionType.AREA;
    }
}
