package net.guerlab.smart.region.core.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import net.guerlab.smart.platform.commons.entity.BaseOrderEntity;

import java.util.Collection;

/**
 * 市
 *
 * @author guer
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel("市")
public class CityDTO extends BaseOrderEntity<CityDTO> {

    /**
     * 市id
     */
    @ApiModelProperty("城市ID")
    private Long cityId;

    /**
     * 市名称
     */
    @ApiModelProperty("城市名称")
    private String cityName;

    /**
     * 省ID
     */
    @ApiModelProperty("省ID")
    private Long provinceId;

    /**
     * 省名称
     */
    @ApiModelProperty("省名称")
    private String provinceName;

    /**
     * 地区列表
     */
    @ApiModelProperty("地区列表")
    private Collection<AreaDTO> children;
}
