/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.region.api.feign.factory;

import feign.hystrix.FallbackFactory;
import net.guerlab.smart.region.api.feign.FeignSearchApi;
import net.guerlab.smart.region.core.entity.GeocoderResult;
import net.guerlab.web.result.Fail;
import net.guerlab.web.result.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeignSearchApiFallbackFactory
implements FallbackFactory<FeignSearchApi> {
    public FeignSearchApi create(Throwable cause) {
        return new FeignSearchApiFallback(cause);
    }

    static class FeignSearchApiFallback
    implements FeignSearchApi {
        private static final Logger log = LoggerFactory.getLogger(FeignSearchApiFallback.class);
        private final Throwable cause;

        @Override
        public Result<GeocoderResult> geocoder(String address) {
            log.error("geocoder fallback", this.cause);
            return new Fail("fallback");
        }

        public FeignSearchApiFallback(Throwable cause) {
            this.cause = cause;
        }
    }
}

