/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.region.api.autoconfig;

import net.guerlab.smart.region.api.SearchApi;
import net.guerlab.smart.region.core.entity.GeocoderResult;
import net.guerlab.smart.region.service.lbs.service.SearchService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.lang.NonNull;

@Configuration
@Conditional(value={WrapperCondition.class})
public class SearchApiLocalServiceAutoConfigure {
    @Bean
    @ConditionalOnBean(value={SearchService.class})
    public SearchApi searchApiLocalServiceWrapper(SearchService service) {
        return new SearchApiLocalServiceWrapper(service);
    }

    private static class SearchApiLocalServiceWrapper
    implements SearchApi {
        private final SearchService service;

        @Override
        public GeocoderResult geocoder(String address) {
            return this.service.geocoder(address);
        }

        public SearchApiLocalServiceWrapper(SearchService service) {
            this.service = service;
        }
    }

    static class WrapperCondition
    implements Condition {
        WrapperCondition() {
        }

        public boolean matches(@NonNull ConditionContext context, @NonNull AnnotatedTypeMetadata metadata) {
            try {
                return WrapperCondition.class.getClassLoader().loadClass("net.guerlab.smart.region.service.lbs.service.SearchService") != null;
            }
            catch (Exception e) {
                return false;
            }
        }
    }
}

