/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.region.api.autoconfig;

import java.util.Optional;
import net.guerlab.smart.region.api.SearchApi;
import net.guerlab.smart.region.api.autoconfig.SearchApiLocalServiceAutoConfigure;
import net.guerlab.smart.region.api.feign.FeignSearchApi;
import net.guerlab.smart.region.core.entity.GeocoderResult;
import net.guerlab.smart.region.core.exception.LbsQueryInvalidException;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={SearchApiLocalServiceAutoConfigure.class})
public class SearchApiFeignAutoConfigure {
    @Bean
    @ConditionalOnMissingBean(value={SearchApi.class})
    public SearchApi searchApiFeignWrapper(FeignSearchApi api) {
        return new SearchApiFeignWrapper(api);
    }

    private static class SearchApiFeignWrapper
    implements SearchApi {
        private final FeignSearchApi api;

        @Override
        public GeocoderResult geocoder(String address) {
            return Optional.ofNullable((GeocoderResult)this.api.geocoder(address).getData()).orElseThrow(LbsQueryInvalidException::new);
        }

        public SearchApiFeignWrapper(FeignSearchApi api) {
            this.api = api;
        }
    }
}

