/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.region.api.autoconfig;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.guerlab.smart.region.api.RegionApi;
import net.guerlab.smart.region.api.autoconfig.RegionApiLocalServiceAutoConfigure;
import net.guerlab.smart.region.api.feign.FeignRegionApi;
import net.guerlab.smart.region.core.domain.RegionDTO;
import net.guerlab.smart.region.core.exception.RegionInvalidException;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={RegionApiLocalServiceAutoConfigure.class})
public class RegionApiFeignAutoConfigure {
    @Bean
    @ConditionalOnMissingBean(value={RegionApi.class})
    public RegionApi regionApiFeignWrapper(FeignRegionApi api) {
        return new RegionApiFeignWrapper(api);
    }

    private static class RegionApiFeignWrapper
    implements RegionApi {
        private final FeignRegionApi api;

        @Override
        public RegionDTO findOne(Long areaId) {
            return Optional.ofNullable((RegionDTO)this.api.findOne(areaId).getData()).orElseThrow(RegionInvalidException::new);
        }

        @Override
        public List<RegionDTO> findChildren(Long regionId) {
            return Optional.ofNullable((List)this.api.findChildren(regionId).getData()).orElse(Collections.emptyList());
        }

        @Override
        public List<RegionDTO> findDepthList(Long regionId) {
            return Optional.ofNullable((List)this.api.findDepthList(regionId).getData()).orElse(Collections.emptyList());
        }

        @Override
        public List<RegionDTO> tree() {
            return Optional.ofNullable((List)this.api.tree().getData()).orElse(Collections.emptyList());
        }

        public RegionApiFeignWrapper(FeignRegionApi api) {
            this.api = api;
        }
    }
}

