package net.guerlab.smart.region.api.feign.factory;

import feign.hystrix.FallbackFactory;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import net.guerlab.smart.region.api.feign.FeignSearchApi;
import net.guerlab.smart.region.core.entity.GeocoderResult;
import net.guerlab.web.result.Fail;
import net.guerlab.web.result.Result;

/**
 * 地区服务接口快速失败类构建工厂
 *
 * @author guer
 */
public class FeignSearchApiFallbackFactory implements FallbackFactory<FeignSearchApi> {

    @Override
    public FeignSearchApi create(Throwable cause) {
        return new FeignSearchApiFallback(cause);
    }

    /**
     * 地区服务接口快速失败实现
     */
    @Slf4j
    @AllArgsConstructor
    static class FeignSearchApiFallback implements FeignSearchApi {

        private final Throwable cause;

        @Override
        public Result<GeocoderResult> geocoder(String address) {
            log.error("geocoder fallback", cause);
            return new Fail<>("fallback");
        }
    }

}
