package net.guerlab.smart.region.api.feign;

import net.guerlab.smart.region.api.feign.factory.FeignSearchApiFallbackFactory;
import net.guerlab.smart.region.core.entity.GeocoderResult;
import net.guerlab.web.result.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * lbs搜索服务接口
 *
 * @author guer
 */
@FeignClient(name = "region/commons/search", fallbackFactory = FeignSearchApiFallbackFactory.class)
public interface FeignSearchApi {

    /**
     * 查询正地理编码结果
     *
     * @param address
     *         结构化地址信息
     * @return 正地理编码结果
     */
    @GetMapping("/geocoder")
    Result<GeocoderResult> geocoder(@RequestParam("address") String address);
}
