package net.guerlab.smart.region.api.feign;

import net.guerlab.smart.region.api.feign.factory.FeignRegionApiFallbackFactory;
import net.guerlab.smart.region.core.domain.RegionDTO;
import net.guerlab.web.result.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;

import java.util.List;

/**
 * 地区服务接口
 *
 * @author guer
 */
@FeignClient(name = "region/commons/region", fallbackFactory = FeignRegionApiFallbackFactory.class)
public interface FeignRegionApi {

    /**
     * 根据地区id查询地区
     *
     * @param regionId
     *         地区id
     * @return 地区
     */
    @GetMapping("/{regionId}")
    Result<RegionDTO> findOne(@PathVariable("regionId") Long regionId);

    /**
     * 根据地区id查询下级列表
     *
     * @param regionId
     *         地区ID
     * @return 下级列表
     */
    @GetMapping("/{regionId}/children")
    Result<List<RegionDTO>> findChildren(@PathVariable("regionId") Long regionId);

    /**
     * 获取深度列表
     *
     * @param regionId
     *         地区ID
     * @return 深度列表
     */
    @GetMapping("/{regionId}/depth")
    Result<List<RegionDTO>> findDepthList(@PathVariable("regionId") Long regionId);

    /**
     * 根据搜索参数查询地区列表
     *
     * @return 地区树
     */
    @GetMapping("/tree")
    Result<List<RegionDTO>> tree();
}
