package net.guerlab.smart.region.api.autoconfig;

import lombok.AllArgsConstructor;
import net.guerlab.smart.region.api.SearchApi;
import net.guerlab.smart.region.api.feign.FeignSearchApi;
import net.guerlab.smart.region.core.entity.GeocoderResult;
import net.guerlab.smart.region.core.exception.LbsQueryInvalidException;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.Optional;

/**
 * @author guer
 */
@Configuration
@AutoConfigureAfter(SearchApiLocalServiceAutoConfigure.class)
public class SearchApiFeignAutoConfigure {

    @SuppressWarnings("SpringJavaInjectionPointsAutowiringInspection")
    @Bean
    @ConditionalOnMissingBean(SearchApi.class)
    public SearchApi searchApiFeignWrapper(FeignSearchApi api) {
        return new SearchApiFeignWrapper(api);
    }

    @AllArgsConstructor
    private static class SearchApiFeignWrapper implements SearchApi {

        private final FeignSearchApi api;

        @Override
        public GeocoderResult geocoder(String address) {
            return Optional.ofNullable(api.geocoder(address).getData()).orElseThrow(LbsQueryInvalidException::new);
        }
    }

}
