package net.guerlab.smart.region.api.autoconfig;

import lombok.AllArgsConstructor;
import net.guerlab.smart.region.api.RegionApi;
import net.guerlab.smart.region.api.feign.FeignRegionApi;
import net.guerlab.smart.region.core.domain.RegionDTO;
import net.guerlab.smart.region.core.exception.RegionInvalidException;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.Collections;
import java.util.List;
import java.util.Optional;

/**
 * @author guer
 */
@Configuration
@AutoConfigureAfter(RegionApiLocalServiceAutoConfigure.class)
public class RegionApiFeignAutoConfigure {

    @SuppressWarnings("SpringJavaInjectionPointsAutowiringInspection")
    @Bean
    @ConditionalOnMissingBean(RegionApi.class)
    public RegionApi regionApiFeignWrapper(FeignRegionApi api) {
        return new RegionApiFeignWrapper(api);
    }

    @AllArgsConstructor
    private static class RegionApiFeignWrapper implements RegionApi {

        private final FeignRegionApi api;

        @Override
        public RegionDTO findOne(Long areaId) {
            return Optional.ofNullable(api.findOne(areaId).getData()).orElseThrow(RegionInvalidException::new);
        }

        @Override
        public List<RegionDTO> findChildren(Long regionId) {
            return Optional.ofNullable(api.findChildren(regionId).getData()).orElse(Collections.emptyList());
        }

        @Override
        public List<RegionDTO> findDepthList(Long regionId) {
            return Optional.ofNullable(api.findDepthList(regionId).getData()).orElse(Collections.emptyList());
        }

        @Override
        public List<RegionDTO> tree() {
            return Optional.ofNullable(api.tree().getData()).orElse(Collections.emptyList());
        }
    }

}
