/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.region.api.autoconfig;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.guerlab.commons.collection.CollectionUtil;
import net.guerlab.smart.platform.commons.util.BeanConvertUtils;
import net.guerlab.smart.platform.commons.util.TreeUtils;
import net.guerlab.smart.region.api.RegionApi;
import net.guerlab.smart.region.core.domain.RegionDTO;
import net.guerlab.smart.region.core.exception.RegionInvalidException;
import net.guerlab.smart.region.core.searchparams.RegionSearchParams;
import net.guerlab.smart.region.service.entity.Region;
import net.guerlab.smart.region.service.service.RegionService;
import net.guerlab.spring.commons.dto.DefaultConvertDTO;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import net.guerlab.web.result.ListObject;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.lang.NonNull;

@Configuration
@Conditional(value={WrapperCondition.class})
public class RegionApiLocalServiceAutoConfigure {
    @Bean
    @ConditionalOnBean(value={RegionService.class})
    public RegionApi regionApiLocalServiceWrapper(RegionService service) {
        return new RegionApiLocalServiceWrapper(service);
    }

    private static class RegionApiLocalServiceWrapper
    implements RegionApi {
        private RegionService service;

        @Override
        public RegionDTO findOne(Long areaId) {
            return (RegionDTO)((Region)this.service.selectByIdOptional((Object)areaId).orElseThrow(RegionInvalidException::new)).toDTO();
        }

        @Override
        public ListObject<RegionDTO> findList(RegionSearchParams searchParams) {
            return BeanConvertUtils.toListObject((ListObject)this.service.selectPage((AbstractSearchParams)searchParams));
        }

        @Override
        public List<RegionDTO> findAll(RegionSearchParams searchParams) {
            return BeanConvertUtils.toList((Collection)this.service.selectAll((AbstractSearchParams)searchParams));
        }

        @Override
        public List<RegionDTO> tree() {
            return new ArrayList<RegionDTO>(TreeUtils.tree((Collection)CollectionUtil.toList((Collection)this.service.selectAll(), DefaultConvertDTO::toDTO)));
        }

        @Override
        public List<RegionDTO> findDepthList(Long regionId) {
            return new ArrayList<RegionDTO>(CollectionUtil.toList((Collection)this.service.findDepthList(regionId), DefaultConvertDTO::toDTO));
        }

        public RegionApiLocalServiceWrapper(RegionService service) {
            this.service = service;
        }
    }

    static class WrapperCondition
    implements Condition {
        WrapperCondition() {
        }

        public boolean matches(@NonNull ConditionContext context, @NonNull AnnotatedTypeMetadata metadata) {
            try {
                return WrapperCondition.class.getClassLoader().loadClass("net.guerlab.smart.region.service.service.RegionService") != null;
            }
            catch (Exception e) {
                return false;
            }
        }
    }
}

