package net.guerlab.smart.region.api.feign.factory;

import feign.hystrix.FallbackFactory;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import net.guerlab.smart.region.api.feign.FeignRegionApi;
import net.guerlab.smart.region.core.domain.RegionDTO;
import net.guerlab.web.result.Fail;
import net.guerlab.web.result.ListObject;
import net.guerlab.web.result.Result;

import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * 地区服务接口快速失败类构建工厂
 *
 * @author guer
 */
public class FeignRegionApiFallbackFactory implements FallbackFactory<FeignRegionApi> {

    @Override
    public FeignRegionApi create(Throwable cause) {
        return new FeignRegionApiFallback(cause);
    }

    /**
     * 地区服务接口快速失败实现
     */
    @Slf4j
    @AllArgsConstructor
    static class FeignRegionApiFallback implements FeignRegionApi {

        private final Throwable cause;

        @Override
        public Result<RegionDTO> findOne(Long streetId) {
            log.error("findOne fallback", cause);
            return new Fail<>("fallback");
        }

        @Override
        public Result<ListObject<RegionDTO>> findList(Map<String, Object> searchParams) {
            log.error("findList fallback", cause);
            return new Fail<>("fallback", ListObject.empty());
        }

        @Override
        public Result<List<RegionDTO>> findAll(Map<String, Object> searchParams) {
            log.error("findAll fallback", cause);
            return new Fail<>("fallback", Collections.emptyList());
        }

        @Override
        public Result<List<RegionDTO>> tree() {
            log.error("tree fallback", cause);
            return new Fail<>("fallback", Collections.emptyList());
        }

        @Override
        public Result<List<RegionDTO>> findDepthList(Long regionId) {
            log.error("findDepthList fallback", cause);
            return new Fail<>("fallback", Collections.emptyList());
        }
    }

}
