package net.guerlab.smart.region.api.autoconfig;

import lombok.AllArgsConstructor;
import net.guerlab.smart.region.api.RegionApi;
import net.guerlab.smart.region.api.feign.FeignRegionApi;
import net.guerlab.smart.region.core.domain.RegionDTO;
import net.guerlab.smart.region.core.exception.RegionInvalidException;
import net.guerlab.smart.region.core.searchparams.RegionSearchParams;
import net.guerlab.spring.searchparams.SearchParamsUtils;
import net.guerlab.web.result.ListObject;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.*;

/**
 * @author guer
 */
@Configuration
@AutoConfigureAfter(RegionApiLocalServiceAutoConfigure.class)
public class RegionApiFeignAutoConfigure {

    @SuppressWarnings("SpringJavaInjectionPointsAutowiringInspection")
    @Bean
    @ConditionalOnMissingBean(RegionApi.class)
    public RegionApi regionApiFeignWrapper(FeignRegionApi api) {
        return new RegionApiFeignWrapper(api);
    }

    @AllArgsConstructor
    private static class RegionApiFeignWrapper implements RegionApi {

        private FeignRegionApi api;

        @Override
        public RegionDTO findOne(Long areaId) {
            return Optional.ofNullable(api.findOne(areaId).getData()).orElseThrow(RegionInvalidException::new);
        }

        @Override
        public ListObject<RegionDTO> findList(RegionSearchParams searchParams) {
            Map<String, Object> params = new HashMap<>(8);
            SearchParamsUtils.handler(searchParams, params);
            return Optional.ofNullable(api.findList(params).getData()).orElse(ListObject.empty());
        }

        @Override
        public List<RegionDTO> findAll(RegionSearchParams searchParams) {
            Map<String, Object> params = new HashMap<>(8);
            SearchParamsUtils.handler(searchParams, params);
            return Optional.ofNullable(api.findAll(params).getData()).orElse(Collections.emptyList());
        }

        @Override
        public List<RegionDTO> tree() {
            return Optional.ofNullable(api.tree().getData()).orElse(Collections.emptyList());
        }

        @Override
        public List<RegionDTO> findDepthList(Long regionId) {
            return Optional.ofNullable(api.findDepthList(regionId).getData()).orElse(Collections.emptyList());
        }
    }

}
