/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.region.api.feign.factory;

import feign.hystrix.FallbackFactory;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.guerlab.smart.region.api.feign.FeignRegionApi;
import net.guerlab.smart.region.core.domain.RegionDTO;
import net.guerlab.web.result.Fail;
import net.guerlab.web.result.ListObject;
import net.guerlab.web.result.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeignRegionApiFallbackFactory
implements FallbackFactory<FeignRegionApi> {
    public FeignRegionApi create(Throwable cause) {
        return new FeignRegionApiFallback(cause);
    }

    static class FeignRegionApiFallback
    implements FeignRegionApi {
        private static final Logger log = LoggerFactory.getLogger(FeignRegionApiFallback.class);
        private final Throwable cause;

        @Override
        public Result<RegionDTO> findOne(Long streetId) {
            log.error("findOne fallback", this.cause);
            return new Fail("fallback");
        }

        @Override
        public Result<ListObject<RegionDTO>> findList(Map<String, Object> searchParams) {
            log.error("findList fallback", this.cause);
            return new Fail("fallback", (Object)ListObject.empty());
        }

        @Override
        public Result<List<RegionDTO>> findAll(Map<String, Object> searchParams) {
            log.error("findAll fallback", this.cause);
            return new Fail("fallback", Collections.emptyList());
        }

        @Override
        public Result<List<RegionDTO>> tree() {
            log.error("tree fallback", this.cause);
            return new Fail("fallback", Collections.emptyList());
        }

        @Override
        public Result<List<RegionDTO>> findDepthList(Long regionId) {
            log.error("findDepthList fallback", this.cause);
            return new Fail("fallback", Collections.emptyList());
        }

        public FeignRegionApiFallback(Throwable cause) {
            this.cause = cause;
        }
    }
}

